<?php

/**
 * Admin interface for MihanVideo Importer
 */

// Security check
if (!isset($_GET['key']) || $_GET['key'] !== 'admin123') {
    http_response_code(403);
    die('Access denied');
}

$config = require_once 'config.php';

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MihanVideo Importer Admin</title>
    <style>
        body {
            font-family: 'Tahoma', Arial, sans-serif;
            background: #f5f5f5;
            margin: 0;
            padding: 20px;
            direction: rtl;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #333;
            text-align: center;
            margin-bottom: 30px;
        }
        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            text-align: center;
            border-left: 4px solid #007cba;
        }
        .stat-number {
            font-size: 2em;
            font-weight: bold;
            color: #007cba;
        }
        .stat-label {
            color: #666;
            margin-top: 5px;
        }
        .actions {
            text-align: center;
            margin: 30px 0;
        }
        .btn {
            background: #007cba;
            color: white;
            padding: 12px 24px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin: 0 10px;
            font-size: 16px;
        }
        .btn:hover {
            background: #005a87;
        }
        .btn-danger {
            background: #dc3545;
        }
        .btn-danger:hover {
            background: #c82333;
        }
        .log-container {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 4px;
            padding: 15px;
            margin-top: 20px;
            max-height: 400px;
            overflow-y: auto;
        }
        .log-entry {
            padding: 5px 0;
            border-bottom: 1px solid #eee;
        }
        .log-error {
            color: #dc3545;
        }
        .log-success {
            color: #28a745;
        }
        .log-warning {
            color: #ffc107;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>مدیریت واردکننده محتوای میهن ویدئو</h1>
        
        <div class="stats">
            <div class="stat-card">
                <div class="stat-number"><?php echo $config['max_videos']; ?></div>
                <div class="stat-label">حداکثر ویدئو</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo $config['min_title_length']; ?></div>
                <div class="stat-label">حداقل طول عنوان</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo $config['max_execution_time']; ?>s</div>
                <div class="stat-label">زمان اجرا</div>
            </div>
        </div>
        
        <div class="actions">
            <a href="s2.php" class="btn" target="_blank">شروع وارد کردن</a>
            <a href="?key=admin123&action=test" class="btn">تست اتصال</a>
            <a href="?key=admin123&action=clear_logs" class="btn btn-danger">پاک کردن لاگ‌ها</a>
        </div>
        
        <?php
        if (isset($_GET['action'])) {
            switch ($_GET['action']) {
                case 'test':
                    echo '<div class="log-container">';
                    echo '<h3>تست اتصال:</h3>';
                    
                    // Test sitemap access
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $config['sitemap_url']);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
                    $result = curl_exec($ch);
                    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    curl_close($ch);
                    
                    if ($httpCode === 200) {
                        echo '<div class="log-entry log-success">✓ دسترسی به sitemap موفق</div>';
                    } else {
                        echo '<div class="log-entry log-error">✗ خطا در دسترسی به sitemap (کد: ' . $httpCode . ')</div>';
                    }
                    
                    // Test WordPress
                    if (file_exists('../wp-load.php')) {
                        echo '<div class="log-entry log-success">✓ فایل WordPress یافت شد</div>';
                    } else {
                        echo '<div class="log-entry log-error">✗ فایل WordPress یافت نشد</div>';
                    }
                    
                    echo '</div>';
                    break;
                    
                case 'clear_logs':
                    // Clear error log (if accessible)
                    if (function_exists('error_log')) {
                        error_log('MihanVideo Importer: Logs cleared by admin');
                        echo '<div class="log-container">';
                        echo '<div class="log-entry log-success">لاگ‌ها پاک شدند</div>';
                        echo '</div>';
                    }
                    break;
            }
        }
        ?>
        
        <div class="log-container">
            <h3>آخرین وضعیت:</h3>
            <div class="log-entry">سیستم آماده اجرا است</div>
            <div class="log-entry">برای شروع وارد کردن، روی دکمه "شروع وارد کردن" کلیک کنید</div>
        </div>
    </div>
</body>
</html>
